/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.scripting.commands;

import com.aptana.editor.common.extensions.IThemeableEditor;
import java.lang.reflect.Method;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public final class TextEditorUtils {
    private TextEditorUtils() {
    }

    public static int getCaretOffset(ITextEditor textEditor) {
        ISelection selection;
        if (textEditor == null) {
            return -1;
        }
        boolean forwardSelection = true;
        Object adapter = textEditor.getAdapter(Control.class);
        if (adapter instanceof StyledText) {
            StyledText styledText = (StyledText)adapter;
            int caretOffset = styledText.getCaretOffset();
            Point selection2 = styledText.getSelection();
            boolean bl = forwardSelection = caretOffset == selection2.y;
        }
        if ((selection = textEditor.getSelectionProvider().getSelection()) instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            if (forwardSelection) {
                return textSelection.getOffset() + textSelection.getLength();
            }
            return textSelection.getOffset();
        }
        return -1;
    }

    public static ISourceViewer getSourceViewer(ITextEditor textEditor) {
        if (textEditor instanceof IThemeableEditor) {
            IThemeableEditor editor = (IThemeableEditor)textEditor;
            return editor.getISourceViewer();
        }
        if (textEditor instanceof AbstractTextEditor) {
            try {
                Method m = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
                m.setAccessible(true);
                return (ISourceViewer)m.invoke((Object)textEditor, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

